import { Router } from "express";
import {
  listActionItems,
  createActionItem,
  patchActionItem,
  listActionItemsByCase,
  archiveActionItem,
  getActionItemAssignees,
  patchActionItemAssignees,
  unarchiveActionItem,
} from "../../../../controllers/api/admin/action-items/action-items.controller.js";

const r = Router();

r.get("/action-items", listActionItems);
r.post("/action-items", createActionItem);

r.patch("/action-items/:actionItemRef", patchActionItem);

// ✅ frontend kompat: POST /archive
r.post("/action-items/:actionItemRef/archive", archiveActionItem);
r.post("/action-items/:actionItemRef/unarchive", unarchiveActionItem);

// (ha akarod, meghagyhatod a delete-et is legacy miatt)
r.delete("/action-items/:actionItemRef", archiveActionItem);

r.get("/action-items/by-case/:caseRef", listActionItemsByCase);

// ✅ Multi-assignees
r.get("/action-items/:actionItemRef/assignees", getActionItemAssignees);
r.patch("/action-items/:actionItemRef/assignees", patchActionItemAssignees);

export default r;
