// src/app/routes/api/app/attachments.router.ts
import { Router } from "express";
import { qmsUpload } from "#imageUpload"; // <-- állítsd be a saját aliasodat
import {
  uploadThreadAttachment,
  downloadAttachment,
  headAttachment,
  uploadMeetingAttachment,
  previewAttachment,
  headPreviewAttachment,
  deleteAttachment,
  removeThreadAttachment,
} from "../../../../controllers/api/admin/attachments/attachments.controller.js";

const r = Router();

// upload threadhez
r.post(
  "/attachments/thread/:threadRef",
  qmsUpload.single("file"),
  uploadThreadAttachment
);

// download + range
r.get(
  "/attachments/:attachmentId([0-9a-fA-F-]{36})/download",
  downloadAttachment
);
r.head("/attachments/:attachmentId([0-9a-fA-F-]{36})/download", headAttachment);
// ✅ PREVIEW (inline)
r.get(
  "/attachments/:attachmentId([0-9a-fA-F-]{36})/preview",
  previewAttachment
);
r.head(
  "/attachments/:attachmentId([0-9a-fA-F-]{36})/preview",
  headPreviewAttachment
);
r.delete("/attachments/:attachmentId([0-9a-fA-F-]{36})", deleteAttachment);
// meeting attachment upload
// r.post(
//   "/attachments/meeting/:meetingId([0-9a-fA-F-]{36})",
//   qmsUpload.single("file"),
//   uploadMeetingAttachment
// );
r.post(
  "/attachments/meeting/:meetingRef",
  qmsUpload.single("file"),
  uploadMeetingAttachment
);
r.delete(
  "/attachments/thread/:threadRef/:attachmentId([0-9a-fA-F-]{36})",
  removeThreadAttachment
);

export default r;
