// src/app/routes/api/admin/cases/cases.router.ts
import { Router } from "express";
import {
  listCases,
  createCase,
  getCaseDetail,
  addCaseMember,
  listCaseMembers,
  updateCase,
  removeCaseMember,
  archiveCase,
  patchCaseMember,
  deleteCaseMember,
  moveCaseOnBoard,
  unarchiveCase, // 👈 ÚJ
} from "../../../../controllers/api/admin/cases/cases.controller.js";

const r = Router();

r.get("/cases", listCases);
r.post("/cases", createCase);

r.get("/cases/:caseRef", getCaseDetail);
r.patch("/cases/:caseRef", updateCase);

// ✅ FE-kompatibilis archive/unarchive
r.post("/cases/:caseRef/archive", archiveCase);
r.post("/cases/:caseRef/unarchive", unarchiveCase);

// ✅ régi kompatibilitás (ha valahol még DELETE megy)
r.delete("/cases/:caseRef", archiveCase);

r.get("/cases/:caseRef/members", listCaseMembers);
r.post("/cases/:caseRef/members", addCaseMember);
r.patch("/cases/:caseRef/members/:userId([0-9a-fA-F-]{36})", patchCaseMember);
r.delete("/cases/:caseRef/members/:userId([0-9a-fA-F-]{36})", deleteCaseMember);
r.delete("/cases/:caseRef/members/:userId([0-9a-fA-F-]{36})", removeCaseMember);

r.post("/cases/:caseRef/board-move", moveCaseOnBoard);

export default r;

// // src/app/routes/api/admin/cases/cases.router.ts
// import { Router } from "express";
// import {
//   listCases,
//   createCase,
//   getCaseDetail,
//   addCaseMember,
//   listCaseMembers,
//   updateCase,
//   removeCaseMember,
//   archiveCase,
//   patchCaseMember,
//   deleteCaseMember,
//   moveCaseOnBoard,
//   unarchiveCase,
// } from "../../../../controllers/api/admin/cases/cases.controller.js";

// const r = Router();

// r.get("/cases", listCases);
// r.post("/cases", createCase);

// r.get("/cases/:caseRef", getCaseDetail);
// r.patch("/cases/:caseRef", updateCase);
// r.delete("/cases/:caseRef", archiveCase);
// r.post("/cases/:caseRef/archive", archiveCase);
// r.post("/cases/:caseRef/unarchive", unarchiveCase);

// r.get("/cases/:caseRef/members", listCaseMembers);
// r.post("/cases/:caseRef/members", addCaseMember);
// r.patch("/cases/:caseRef/members/:userId([0-9a-fA-F-]{36})", patchCaseMember);
// // soft remove / deactivate
// r.delete("/cases/:caseRef/members/:userId([0-9a-fA-F-]{36})", removeCaseMember);

// // hard delete (külön endpoint)
// r.delete(
//   "/cases/:caseRef/members/:userId([0-9a-fA-F-]{36})/hard",
//   deleteCaseMember
// );

// r.post("/cases/:caseRef/board-move", moveCaseOnBoard);
// export default r;
