import { Router } from "express";
import {
  listDecisionsByCase,
  createDecision,
  updateDecisionStatus,
  listDecisions,
  getDecisionDetail,
  patchDecision,
  archiveDecision,
  unarchiveDecision,
} from "../../../../controllers/api/admin/decisions/decisions.controller.js";

const r = Router();

r.get("/decisions", listDecisions);
r.get("/decisions/:decisionRef", getDecisionDetail);

r.get("/decisions/by-case/:caseRef", listDecisionsByCase);
r.post("/decisions/by-case/:caseRef", createDecision);

r.patch("/decisions/:decisionRef/status", updateDecisionStatus);

r.patch("/decisions/:decisionRef", patchDecision);
r.delete("/decisions/:decisionRef", archiveDecision);
r.post("/decisions/:decisionRef/archive", archiveDecision);
r.post("/decisions/:decisionRef/unarchive", unarchiveDecision);

export default r;
