import { Router } from "express";
import {
  listThreadsByCase,
  createThread,
  listThreadComments,
  createThreadComment,
  listThreadAttachments,
  patchThread,
  archiveThread,
  patchThreadComment,
  archiveThreadComment,
  getThreadDetail,
} from "../../../../controllers/api/admin/threads/threads.controller.js";

const r = Router();

r.get("/threads/by-case/:caseRef", listThreadsByCase);
r.post("/threads/by-case/:caseRef", createThread);

r.get("/threads/:threadRef/comments", listThreadComments);
r.post("/threads/:threadRef/comments", createThreadComment);

r.get("/threads/:threadRef/attachments", listThreadAttachments);

r.get("/threads/:threadRef", getThreadDetail);
r.patch("/threads/:threadRef", patchThread);
r.delete("/threads/:threadRef", archiveThread);

r.patch(
  "/threads/:threadRef/comments/:commentId([0-9a-fA-F-]{36})",
  patchThreadComment
);
r.delete(
  "/threads/:threadRef/comments/:commentId([0-9a-fA-F-]{36})",
  archiveThreadComment
);

export default r;
